<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Problem extends Model 
{

    protected $table = 'problems';
    public $timestamps = true;

    public function info()
    {
        return $this->hasOne('App\Models\ProblemCode');
    }

    public function problemsSummary()
    {
        return $this->hasMany('App\Models\ModuleProblemUserSummary');
    }

    public function problemsAttempted()
    {
        return $this->hasMany('App\Models\ModuleProblemUserAttempted');
    }

    public function problemType()
    {
        return $this->belongsTo('App\Models\ProblemTypes');
    }

}